﻿<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Informacja DEK-II</title>
		<script runat="server">

	public class PrnParams: Soneta.Business.ContextBase {
		public PrnParams(Context context): base(context) {
			miesiąc = PrevMonth();
		}
		
		YearMonth miesiąc;
		[Required]
		[Caption("Deklaracja za")]
		public YearMonth Miesiąc {
			get { return miesiąc; }
			set {
				if (miesiąc==YearMonth.Empty)
					value = PrevMonth(); 
				miesiąc = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
		YearMonth PrevMonth() {
			Date data = Date.Empty;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			if (data==Date.Empty)
				data = Date.Today;
			return new YearMonth(data)-1;
		}
	}
	
	PrnParams pars = null; 
	[Context] 
	public PrnParams Params { 
		set { pars = value; } 
	}

    Dictionary<OddzialFirmy, List<Pracownik>> dict = new Dictionary<OddzialFirmy, List<Pracownik>>();
    List<OddzialFirmy> oddzialy = new List<OddzialFirmy>();
    string title;
    ZPCHR zpchr;

    void OnContextLoad(Object sender, EventArgs args) {
        ReportHeader1["MIESIĄC"] = pars.Miesiąc.ToString();
        title = ReportHeader1.Title;

        KadryModule kadry = KadryModule.GetInstance(dc);
        Soneta.Business.View view = kadry.Pracownicy.GetNaEtatach(pars.Miesiąc.ToFromTo(), (Wydzial)null, false, true);
        
        List<Pracownik> list;
        if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
            Date data = pars.Miesiąc.FirstDay;
            foreach (Pracownik pracownik in view) {
                PracHistoria ph = pracownik[data];
                OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                while (of != null) {
			        if (of.GetObjectRight() != AccessRights.Denied &&
                        of.Deklaracje.PFRON == NaliczanieDeklaracjiOddziału.Naliczaj)
                        break;
                    of = of.Nadrzedny;
                }
                if (of == null)
                    continue;
                if (!dict.TryGetValue(of, out list))
                    dict.Add(of, list = new List<Pracownik>());
                list.Add(pracownik);
            }
        }
        else {
            dict.Add(new OddzialFirmy(RowCreator.Empty), list = new List<Pracownik>());
            foreach (Pracownik pracownik in view)
                list.Add(pracownik);
        }
            
        zpchr = new ZPCHR(false, pars.Miesiąc, ZPCHR.WarunkiNaliczania.PFRON);
        oddzialy.AddRange(dict.Keys);
        DataRepeater1.DataSource = oddzialy;
    }

	void OnBeforeRow(Object sender, EventArgs args) {
        OddzialFirmy of = (OddzialFirmy)DataRepeater1.CurrentRow;
        ReportHeader1.Title = !string.IsNullOrEmpty(of.Symbol) ? title.Replace("%ODDZIAL%", "Oddział: " + of) : title.Replace("%ODDZIAL%", "");

        decimal e = 0;
        decimal o = 0;

        decimal ez = 0;        
        decimal eu = 0;
        decimal el = 0;
        decimal oz = 0;
        decimal ou = 0;
        decimal ol = 0;

        decimal ezw = 0;
        decimal euw = 0;
        decimal elw = 0;
        decimal ozw = 0;
        decimal ouw = 0;
        decimal olw = 0;

        decimal ezu = 0;
        decimal euu = 0;
        decimal elu = 0;
        decimal ozu = 0;
        decimal ouu = 0;
        decimal olu = 0;

        Set<Pracownik> pracownicy = new Set<Pracownik>();
        foreach (Pracownik p in dict[of]) {
            Pracownik pracownik = p.EtatGłówny;
            if (pracownicy.Contains(pracownik))
                continue;
            pracownicy.Add(pracownik);
            IEnumerable it = zpchr[pracownik];
            Periods okresOsoby = Periods.Empty;
            foreach (ZPCHR.OkresInfo info in it) {
                if (!info.Wchodzi)
                    continue;

                int osoby = (Periods.New(info.Okres) - okresOsoby).Days;
                okresOsoby += info.Okres;
                decimal etaty = (decimal)info.Wymiar * info.Okres.Days;

                e += etaty;
                o += osoby;

                bool umysł = false;
                bool wzrok = false;
                switch (info.TypSchorzenia) {
                    case SzczegolneSchorzenia.Epilepsja:
                    case SzczegolneSchorzenia.UpośledzenieUmysłowe:
                    case SzczegolneSchorzenia.ChorobaPsychiczna:
                        umysł = true;
                        break;
                    case SzczegolneSchorzenia.Niewidomy:
                        wzrok = true;
                        break;
                }

                switch (info.STN) {
                    case StNiepełnosprawności.Brak:
                        continue;
                    case StNiepełnosprawności.Lekki:
                        el += etaty;
                        ol += osoby;
                        if (umysł) {
                            elu += etaty;
                            olu += osoby;
                        }
                        else if (wzrok) {
                            elw += etaty;
                            olw += osoby;
                        }
                        break;
                    case StNiepełnosprawności.Umiarkowany:
                        eu += etaty;
                        ou += osoby;
                        if (umysł) {
                            euu += etaty;
                            ouu += osoby;
                        }
                        else if (wzrok) {
                            euw += etaty;
                            ouw += osoby;
                        }
                        break;
                    case StNiepełnosprawności.Znaczny:
                        ez += etaty;
                        oz += osoby;
                        if (umysł) {
                            ezu += etaty;
                            ozu += osoby;
                        }
                        else if (wzrok) {
                            ezw += etaty;
                            ozw += osoby;
                        }
                        break;
                }
            }
        }

        e =  Soneta.Tools.Math.RoundCy(e/pars.Miesiąc.Days);
        o = Soneta.Tools.Math.RoundCy(o/pars.Miesiąc.Days);
        
        ez = Soneta.Tools.Math.RoundCy(ez/pars.Miesiąc.Days);
        eu = Soneta.Tools.Math.RoundCy(eu/pars.Miesiąc.Days);
        el = Soneta.Tools.Math.RoundCy(el/pars.Miesiąc.Days);
        oz = Soneta.Tools.Math.RoundCy(oz/pars.Miesiąc.Days);
        ou = Soneta.Tools.Math.RoundCy(ou/pars.Miesiąc.Days);
        ol = Soneta.Tools.Math.RoundCy(ol/pars.Miesiąc.Days);

        ezu = Soneta.Tools.Math.RoundCy(ezu/pars.Miesiąc.Days);
        euu = Soneta.Tools.Math.RoundCy(euu/pars.Miesiąc.Days);
        elu = Soneta.Tools.Math.RoundCy(elu/pars.Miesiąc.Days);
        ozu = Soneta.Tools.Math.RoundCy(ozu/pars.Miesiąc.Days);
        ouu = Soneta.Tools.Math.RoundCy(ouu/pars.Miesiąc.Days);
        olu = Soneta.Tools.Math.RoundCy(olu/pars.Miesiąc.Days);

        ezw = Soneta.Tools.Math.RoundCy(ezw/pars.Miesiąc.Days);
        euw = Soneta.Tools.Math.RoundCy(euw/pars.Miesiąc.Days);
        elw = Soneta.Tools.Math.RoundCy(elw/pars.Miesiąc.Days);
        ozw = Soneta.Tools.Math.RoundCy(ozw/pars.Miesiąc.Days);
        ouw = Soneta.Tools.Math.RoundCy(ouw/pars.Miesiąc.Days);
        olw = Soneta.Tools.Math.RoundCy(olw/pars.Miesiąc.Days);

        decimal en;
        
        dlEtatyRazem.EditValue = e;

        dlEtatyNiepełnosprawni.EditValue = en = ez + eu + el;   //35
        dlEtatyZnaczne.EditValue = ez;                          //36
        dlEtatyUmiarkowane.EditValue = eu;                      //39
        dlEtatyLekkie.EditValue = el;                           //42

        dlEtatyZnaczneUmysł.EditValue = ezu;
        dlEtatyUmiarkowaneUmysł.EditValue = euu;
        dlEtatyLekkieUmysł.EditValue = elu;

        dlEtatyZnaczneWzrok.EditValue = ezw;
        dlEtatyUmiarkowaneWzrok.EditValue = euw;

        decimal on;
        dlOsobyRazem.EditValue = o;
        
        dlOsobyNiepełnosprawni.EditValue = on = oz + ou + ol;   //25
        dlOsobyZnaczne.EditValue = oz;                          //26
        dlOsobyUmiarkowane.EditValue = ou;                      //29
        dlOsobyLekkie.EditValue = ol;                           //32
        
        dlOsobyZnaczneUmysł.EditValue = ozu;
        dlOsobyUmiarkowaneUmysł.EditValue = ouu;
        dlOsobyLekkieUmysł.EditValue = olu;
        
        dlOsobyZnaczneWzrok.EditValue = ozw;
        dlOsobyUmiarkowaneWzrok.EditValue = ouw;

        if (e != 0)
            dlWskaźnikZatrudnienia.EditValue = Soneta.Tools.Math.Round(en / e, 4);     //44 = 35/34
    }

    string F(decimal d) {
        return d.ToString("n");
    }    
	static void Msg(object obj) {
	}
	
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	    <style type="text/css">
            .style1 { width: 100%; }
        </style>
	</HEAD>
	<body>
		<form id="InformacjaMiesięcznaINF2" method="post" runat="server">
            <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%" RowTypeName="Soneta.Kadry.ZPCHR+MiesiącInfo,Soneta.KadryPlace"
                onbeforerow="OnBeforeRow">
                <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
				<cc1:reportheader id="ReportHeader1" title="INFORMACJA DLA DEKLARACJI DEK-II&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;BR&gt;Deklaracja miesięcznych wpłat na PFRON&lt;BR&gt;&lt;/strong&gt;Okres sprawozdawczy: &lt;strong&gt;%MIESIĄC%&lt;/SPAN&gt;|Wydruk jest raportem historycznym!|%ODDZIAL%"
					runat="server"></cc1:reportheader>
				<P style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">
					<b>D. Zatrudnienie osób niepełnosprawnych </b>
					</P>
				<P style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">
					<b>D1. Przeciętne zatrudnienie w osobach</b><TABLE id="Table3" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" cellSpacing="0" cellPadding="0"
						width="100%" border="1">
					    <tr>
                            <td align="center" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" width="30%">
                                Zatrudnienie ogółem</td>
                            <td width="5%" align="center">
                                24.</td>
                            <td align="right" width="15%">
                                    <ea:DataLabel ID="dlOsobyRazem" runat="server" 
                                        Format="{0:n}">
                                    </ea:DataLabel>
                            </td>
                            <td align="center" width="30%">
                                            w&nbsp;tym osób niepełnosprawnych ogółem</td>
                            <td width="5%" align="center">
                                25.</td>
                            <td align="right">
                                    <ea:DataLabel ID="dlOsobyNiepełnosprawni" runat="server" 
                                        Format="{0:n}">
                                    </ea:DataLabel>
                            </td>
                        </tr>
					</TABLE>
				</P>
				<P style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">w tym osób niepełnosprawnych 
                    w stopniu:
				    <table align="center" border="1" cellpadding="0" cellspacing="0" class="style1" 
                        style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" width="100%">
                        <tr>
                            <td align="center" colspan="2" rowspan="2" width="34%">
                                znacznym</td>
                            <td colspan="4">
                                W tym:</td>
                        </tr>
                        <tr>
                            <td align="center" colspan="2" width="33%">
                                chorzy na epilepsję<br />
                                upośledzeni umysłowo
                                <br />
                                psychicznie chorzy</td>
                            <td align="center" colspan="2">
                                niewidomi<br />
                                niedowidzący</td>
                        </tr>
                        <tr>
                            <td width="5%" align="center">
                                26.</td>
                            <td align="right">
                                    <ea:DataLabel ID="dlOsobyZnaczne" runat="server" Format="{0:n}">
                                    </ea:DataLabel>
                            </td>
                            <td width="5%" align="center">
                                27.</td>
                            <td align="right">
                                    <ea:DataLabel ID="dlOsobyZnaczneUmysł" runat="server" Format="{0:n}">
                                    </ea:DataLabel>
                            </td>
                            <td width="5%" align="center">
                                28.</td>
                            <td align="right">
                                    <ea:DataLabel ID="dlOsobyZnaczneWzrok" runat="server" Format="{0:n}">
                                    </ea:DataLabel>
                            </td>
                        </tr>
                        <tr>
                            <td align="center" colspan="2" rowspan="2">
                                umiarkowanym</td>
                            <td colspan="4">
                                W tym:</td>
                        </tr>
                        <tr>
                            <td align="center" colspan="2">
                                chorzy na epilepsję<br />
                                upośledzeni umysłowo
                                <br />
                                psychicznie chorzy</td>
                            <td align="center" colspan="2">
                                niewidomi<br />
                                niedowidzący</td>
                        </tr>
                        <tr>
                            <td align="center">
                                29.</td>
                            <td align="right">
                                    <ea:DataLabel ID="dlOsobyUmiarkowane" runat="server" Format="{0:n}">
                                    </ea:DataLabel>
                            </td>
                            <td align="center">
                                30.</td>
                            <td align="right">
                                    <ea:DataLabel ID="dlOsobyUmiarkowaneUmysł" runat="server" Format="{0:n}">
                                    </ea:DataLabel>
                            </td>
                            <td align="center">
                                31.</td>
                            <td align="right">
                                    <ea:DataLabel ID="dlOsobyUmiarkowaneWzrok" runat="server" Format="{0:n}">
                                    </ea:DataLabel>
                            </td>
                        </tr>
                        <tr>
                            <td align="center" colspan="2" rowspan="2" valign="middle">
                                lekkim</td>
                            <td colspan="4">
                                W tym:</td>
                        </tr>
                        <tr>
                            <td align="center" colspan="2">
                                chorzy na epilepsję<br />
                                upośledzeni umysłowo
                                <br />
                                psychicznie chorzy</td>
                            <td align="center" colspan="2" rowspan="2">
                                </td>
                        </tr>
                        <tr>
                            <td align="center">
                                32.</td>
                            <td align="right">
                                    <ea:DataLabel ID="dlOsobyLekkie" runat="server" Format="{0:n}">
                                    </ea:DataLabel>
                            </td>
                            <td align="center">
                                33.</td>
                            <td align="right">
                                    <ea:DataLabel ID="dlOsobyLekkieUmysł" runat="server" Format="{0:n}">
                                    </ea:DataLabel>
                            </td>
                            
                        </tr>
                    </table>
                    </P>
                    <P style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">
                        <b>D2. Przeciętne zatrudnienie w miesiącu w przeliczeniu na pełny wymiar czasu 
                        pracy</b>
                        <table id="Table1" border="1" cellpadding="0" cellspacing="0" 
                            style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" width="100%">
                            <tr>
                                <td align="center" width="30%">
                                    Zatrudnienie ogółem:</td>
                                <td width="5%" align="center">
                                    34.</td>
                                <td align="right" width="15%">
                                <ea:DataLabel ID="dlEtatyRazem" runat="server" Format="{0:n}">
                                </ea:DataLabel>
                                </td>
                                <td align="center" width="30%">
                                    w&nbsp;tym etatów osób niepełnosprawnych ogółem</td>
                                <td width="5%" align="center">
                                    35.</td>
                                <td align="right">
                                <ea:DataLabel ID="dlEtatyNiepełnosprawni" runat="server" 
                                    Format="{0:n}">
                                </ea:DataLabel>
                                </td>
                            </tr>
                        </table>
                    </p>
                    <p style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">
                        w tym etatów osób niepełnosprawnych w stopniu:
                        <table align="center" border="1" cellpadding="0" cellspacing="0" class="style1" 
                            style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" width="100%">
                            <tr>
                                <td align="center" colspan="2" rowspan="2" width="34%">
                                    znacznym</td>
                                <td colspan="4">
                                    W tym:</td>
                            </tr>
                            <tr>
                                <td align="center" colspan="2" width="33%">
                                    chorzy na epilepsję<br />
                                    upośledzeni umysłowo
                                    <br />
                                    psychicznie chorzy</td>
                                <td align="center" colspan="2">
                                    niewidomi<br />
                                    niedowidzący</td>
                            </tr>
                            <tr>
                                <td width="5%" align="center">
                                    36.</td>
                                <td align="right">
                                <ea:DataLabel ID="dlEtatyZnaczne" runat="server" Format="{0:n}">
                                </ea:DataLabel>
                                </td>
                                <td width="5%" align="center">
                                    37.</td>
                                <td align="right">
                                <ea:DataLabel ID="dlEtatyZnaczneUmysł" runat="server" Format="{0:n}">
                                </ea:DataLabel>
                                </td>
                                <td width="5%" align="center">
                                    38.</td>
                                <td align="right">
                                <ea:DataLabel ID="dlEtatyZnaczneWzrok" runat="server" Format="{0:n}">
                                </ea:DataLabel>
                                </td>
                            </tr>
                            <tr>
                                <td align="center" colspan="2" rowspan="2">
                                    umiarkowanym</td>
                                <td colspan="4">
                                    W tym:</td>
                            </tr>
                            <tr>
                                <td align="center" colspan="2">
                                    chorzy na epilepsję<br />
                                    upośledzeni umysłowo
                                    <br />
                                    psychicznie chorzy</td>
                                <td align="center" colspan="2">
                                    niewidomi<br />
                                    niedowidzący</td>
                            </tr>
                            <tr>
                                <td align="center">
                                    39.</td>
                                <td align="right">
                                <ea:DataLabel ID="dlEtatyUmiarkowane" runat="server" Format="{0:n}">
                                </ea:DataLabel>
                                </td>
                                <td align="center">
                                    40.</td>
                                <td align="right">
                                <ea:DataLabel ID="dlEtatyUmiarkowaneUmysł" runat="server" Format="{0:n}">
                                </ea:DataLabel>
                                </td>
                                <td align="center">
                                    41.</td>
                                <td align="right">
                                <ea:DataLabel ID="dlEtatyUmiarkowaneWzrok" runat="server" Format="{0:n}">
                                </ea:DataLabel>
                                </td>
                            </tr>
                            <tr>
                                <td align="center" colspan="2" rowspan="2" valign="middle">
                                    lekkim</td>
                                <td colspan="4">
                                    W tym:</td>
                            </tr>
                            <tr>
                                <td align="center" colspan="2">
                                    chorzy na epilepsję<br />
                                    upośledzeni umysłowo
                                    <br />
                                    psychicznie chorzy</td>
                                <td align="center" colspan="2" rowspan="2"></td>
                            </tr>
                            <tr>
                                <td align="center">
                                    42.</td>
                                <td align="right">
                                <ea:DataLabel ID="dlEtatyLekkie" runat="server" Format="{0:n}">
                                </ea:DataLabel>
                                </td>
                                <td align="center">
                                    43.</td>
                                <td align="right">
                                <ea:DataLabel ID="dlEtatyLekkieUmysł" runat="server" Format="{0:n}">
                                </ea:DataLabel>
                                </td>

                            </tr>
                            <tr>
                                <td colspan="4" align="right">Wskaźnik zatrudnienia osób niepełnosprawnych<br /><i>poz. 35/poz. 34</i>
                                </td>
                                <td colspan="2" align="right">
                                    <ea:DataLabel ID="dlWskaźnikZatrudnienia" runat="server" Format="{0:0.0000}">
                                </ea:DataLabel>
                                </td>
                            </tr>
                        </table>
                    </p>
    			<cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
			</ea:DataRepeater>
		</form>
	</body>
</HTML>
